/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media.codec.atrac3plus;

import java.util.Arrays;
import jpcsp.media.codec.atrac3plus.Atrac3plusData1;
import jpcsp.media.codec.atrac3plus.Atrac3plusData2;
import jpcsp.media.codec.atrac3plus.Atrac3plusDecoder;
import jpcsp.media.codec.atrac3plus.Atrac3plusDsp;
import jpcsp.media.codec.atrac3plus.AtracGainInfo;
import jpcsp.media.codec.atrac3plus.Channel;
import jpcsp.media.codec.atrac3plus.ChannelUnitContext;
import jpcsp.media.codec.atrac3plus.Context;
import jpcsp.media.codec.atrac3plus.WaveSynthParams;
import jpcsp.media.codec.atrac3plus.WavesData;
import jpcsp.media.codec.util.BitReader;
import jpcsp.media.codec.util.CodecUtils;
import jpcsp.media.codec.util.VLC;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class ChannelUnit {
    private static Logger log = Atrac3plusDecoder.log;
    public ChannelUnitContext ctx = new ChannelUnitContext();
    private BitReader br;
    private Atrac3plusDsp dsp;
    private int numChannels;
    private static final VLC[] wl_vlc_tabs = new VLC[4];
    private static final VLC[] sf_vlc_tabs = new VLC[8];
    private static final VLC[] ct_vlc_tabs = new VLC[4];
    private static final VLC[] spec_vlc_tabs = new VLC[112];
    private static final VLC[] gain_vlc_tabs = new VLC[11];
    private static final VLC[] tone_vlc_tabs = new VLC[7];
    private static final int[] wl_nb_bits = new int[]{2, 3, 5, 5};
    private static final int[] wl_nb_codes = new int[]{3, 5, 8, 8};
    private static final int[][] wl_bits = new int[][]{Atrac3plusData2.atrac3p_wl_huff_bits1, Atrac3plusData2.atrac3p_wl_huff_bits2, Atrac3plusData2.atrac3p_wl_huff_bits3, Atrac3plusData2.atrac3p_wl_huff_bits4};
    private static final int[][] wl_codes = new int[][]{Atrac3plusData2.atrac3p_wl_huff_code1, Atrac3plusData2.atrac3p_wl_huff_code2, Atrac3plusData2.atrac3p_wl_huff_code3, Atrac3plusData2.atrac3p_wl_huff_code4};
    private static final int[][] wl_xlats = new int[][]{Atrac3plusData2.atrac3p_wl_huff_xlat1, Atrac3plusData2.atrac3p_wl_huff_xlat2, null, null};
    private static final int[] ct_nb_bits = new int[]{3, 4, 4, 4};
    private static final int[] ct_nb_codes = new int[]{4, 8, 8, 8};
    private static final int[][] ct_bits = new int[][]{Atrac3plusData2.atrac3p_ct_huff_bits1, Atrac3plusData2.atrac3p_ct_huff_bits2, Atrac3plusData2.atrac3p_ct_huff_bits2, Atrac3plusData2.atrac3p_ct_huff_bits3};
    private static final int[][] ct_codes = new int[][]{Atrac3plusData2.atrac3p_ct_huff_code1, Atrac3plusData2.atrac3p_ct_huff_code2, Atrac3plusData2.atrac3p_ct_huff_code2, Atrac3plusData2.atrac3p_ct_huff_code3};
    private static final int[][] ct_xlats = new int[][]{null, null, Atrac3plusData2.atrac3p_ct_huff_xlat1, null};
    private static final int[] sf_nb_bits = new int[]{9, 9, 9, 9, 6, 6, 7, 7};
    private static final int[] sf_nb_codes = new int[]{64, 64, 64, 64, 16, 16, 16, 16};
    private static final int[][] sf_bits = new int[][]{Atrac3plusData2.atrac3p_sf_huff_bits1, Atrac3plusData2.atrac3p_sf_huff_bits1, Atrac3plusData2.atrac3p_sf_huff_bits2, Atrac3plusData2.atrac3p_sf_huff_bits3, Atrac3plusData2.atrac3p_sf_huff_bits4, Atrac3plusData2.atrac3p_sf_huff_bits4, Atrac3plusData2.atrac3p_sf_huff_bits5, Atrac3plusData2.atrac3p_sf_huff_bits6};
    private static final int[][] sf_codes = new int[][]{Atrac3plusData2.atrac3p_sf_huff_code1, Atrac3plusData2.atrac3p_sf_huff_code1, Atrac3plusData2.atrac3p_sf_huff_code2, Atrac3plusData2.atrac3p_sf_huff_code3, Atrac3plusData2.atrac3p_sf_huff_code4, Atrac3plusData2.atrac3p_sf_huff_code4, Atrac3plusData2.atrac3p_sf_huff_code5, Atrac3plusData2.atrac3p_sf_huff_code6};
    private static final int[][] sf_xlats = new int[][]{Atrac3plusData2.atrac3p_sf_huff_xlat1, Atrac3plusData2.atrac3p_sf_huff_xlat2, null, null, Atrac3plusData2.atrac3p_sf_huff_xlat4, Atrac3plusData2.atrac3p_sf_huff_xlat5, null, null};
    private static final int[][] gain_cbs = new int[][]{Atrac3plusData2.atrac3p_huff_gain_npoints1_cb, Atrac3plusData2.atrac3p_huff_gain_npoints1_cb, Atrac3plusData2.atrac3p_huff_gain_lev1_cb, Atrac3plusData2.atrac3p_huff_gain_lev2_cb, Atrac3plusData2.atrac3p_huff_gain_lev3_cb, Atrac3plusData2.atrac3p_huff_gain_lev4_cb, Atrac3plusData2.atrac3p_huff_gain_loc3_cb, Atrac3plusData2.atrac3p_huff_gain_loc1_cb, Atrac3plusData2.atrac3p_huff_gain_loc4_cb, Atrac3plusData2.atrac3p_huff_gain_loc2_cb, Atrac3plusData2.atrac3p_huff_gain_loc5_cb};
    private static final int[][] gain_xlats = new int[][]{null, Atrac3plusData2.atrac3p_huff_gain_npoints2_xlat, Atrac3plusData2.atrac3p_huff_gain_lev1_xlat, Atrac3plusData2.atrac3p_huff_gain_lev2_xlat, Atrac3plusData2.atrac3p_huff_gain_lev3_xlat, Atrac3plusData2.atrac3p_huff_gain_lev4_xlat, Atrac3plusData2.atrac3p_huff_gain_loc3_xlat, Atrac3plusData2.atrac3p_huff_gain_loc1_xlat, Atrac3plusData2.atrac3p_huff_gain_loc4_xlat, Atrac3plusData2.atrac3p_huff_gain_loc2_xlat, Atrac3plusData2.atrac3p_huff_gain_loc5_xlat};
    private static final int[][] tone_cbs = new int[][]{Atrac3plusData2.atrac3p_huff_tonebands_cb, Atrac3plusData2.atrac3p_huff_numwavs1_cb, Atrac3plusData2.atrac3p_huff_numwavs2_cb, Atrac3plusData2.atrac3p_huff_wav_ampsf1_cb, Atrac3plusData2.atrac3p_huff_wav_ampsf2_cb, Atrac3plusData2.atrac3p_huff_wav_ampsf3_cb, Atrac3plusData2.atrac3p_huff_freq_cb};
    private static final int[][] tone_xlats = new int[][]{null, null, Atrac3plusData2.atrac3p_huff_numwavs2_xlat, Atrac3plusData2.atrac3p_huff_wav_ampsf1_xlat, Atrac3plusData2.atrac3p_huff_wav_ampsf2_xlat, Atrac3plusData2.atrac3p_huff_wav_ampsf3_xlat, Atrac3plusData2.atrac3p_huff_freq_xlat};

    public static void init() {
        int i;
        for (i = 0; i < 4; ++i) {
            ChannelUnit.wl_vlc_tabs[i] = new VLC();
            wl_vlc_tabs[i].initVLCSparse(wl_nb_bits[i], wl_nb_codes[i], wl_bits[i], wl_codes[i], wl_xlats[i]);
            ChannelUnit.ct_vlc_tabs[i] = new VLC();
            ct_vlc_tabs[i].initVLCSparse(ct_nb_bits[i], ct_nb_codes[i], ct_bits[i], ct_codes[i], ct_xlats[i]);
        }
        for (i = 0; i < 8; ++i) {
            ChannelUnit.sf_vlc_tabs[i] = new VLC();
            sf_vlc_tabs[i].initVLCSparse(sf_nb_bits[i], sf_nb_codes[i], sf_bits[i], sf_codes[i], sf_xlats[i]);
        }
        for (i = 0; i < 112; ++i) {
            if (Atrac3plusData1.atrac3p_spectra_tabs[i].cb == null) continue;
            ChannelUnit.spec_vlc_tabs[i] = new VLC();
            ChannelUnit.buildCanonicalHuff(Atrac3plusData1.atrac3p_spectra_tabs[i].cb, Atrac3plusData1.atrac3p_spectra_tabs[i].xlat, spec_vlc_tabs[i]);
        }
        for (i = 0; i < 11; ++i) {
            ChannelUnit.gain_vlc_tabs[i] = new VLC();
            ChannelUnit.buildCanonicalHuff(gain_cbs[i], gain_xlats[i], gain_vlc_tabs[i]);
        }
        for (i = 0; i < 7; ++i) {
            ChannelUnit.tone_vlc_tabs[i] = new VLC();
            ChannelUnit.buildCanonicalHuff(tone_cbs[i], tone_xlats[i], tone_vlc_tabs[i]);
        }
    }

    private static int buildCanonicalHuff(int[] cb, int[] xlat, VLC vlc) {
        int[] codes = new int[256];
        int[] bits = new int[256];
        int cbIndex = 0;
        int index = 0;
        int code = 0;
        int minLen = cb[cbIndex++];
        int maxLen = cb[cbIndex++];
        for (int b = minLen; b <= maxLen; ++b) {
            for (int i = cb[cbIndex++]; i > 0; --i) {
                bits[index] = b;
                codes[index] = code++;
                ++index;
            }
            code <<= 1;
        }
        return vlc.initVLCSparse(maxLen, index, bits, codes, xlat);
    }

    public void setBitReader(BitReader br) {
        this.br = br;
    }

    public void setDsp(Atrac3plusDsp dsp) {
        this.dsp = dsp;
    }

    public void setNumChannels(int numChannels) {
        this.numChannels = numChannels;
    }

    public int decode() {
        this.ctx.numQuantUnits = this.br.read(5) + 1;
        if (this.ctx.numQuantUnits > 28 && this.ctx.numQuantUnits < 32) {
            log.error((Object)String.format("Invalid number of quantization units: %d", this.ctx.numQuantUnits));
            return -1;
        }
        this.ctx.muteFlag = this.br.readBool();
        int ret = this.decodeQuantWordlen();
        if (ret < 0) {
            return ret;
        }
        this.ctx.numSubbands = Atrac3plusData2.atrac3p_qu_to_subband[this.ctx.numQuantUnits - 1] + 1;
        this.ctx.numCodedSubbands = this.ctx.usedQuantUnits > 0 ? Atrac3plusData2.atrac3p_qu_to_subband[this.ctx.usedQuantUnits - 1] + 1 : 0;
        ret = this.decodeScaleFactors();
        if (ret < 0) {
            return ret;
        }
        ret = this.decodeCodeTableIndexes();
        if (ret < 0) {
            return ret;
        }
        this.decodeSpectrum();
        if (this.numChannels == 2) {
            this.getSubbandFlags(this.ctx.swapChannels, this.ctx.numCodedSubbands);
            this.getSubbandFlags(this.ctx.negateCoeffs, this.ctx.numCodedSubbands);
        }
        this.decodeWindowShape();
        ret = this.decodeGaincData();
        if (ret < 0) {
            return ret;
        }
        ret = this.decodeTonesInfo();
        if (ret < 0) {
            return ret;
        }
        this.ctx.noisePresent = this.br.readBool();
        if (this.ctx.noisePresent) {
            this.ctx.noiseLevelIndex = this.br.read(4);
            this.ctx.noiseTableIndex = this.br.read(4);
        }
        return 0;
    }

    private int numCodedUnits(Channel chan) {
        chan.fillMode = this.br.read(2);
        if (chan.fillMode == 0) {
            chan.numCodedVals = this.ctx.numQuantUnits;
        } else {
            chan.numCodedVals = this.br.read(5);
            if (chan.numCodedVals > this.ctx.numQuantUnits) {
                log.error((Object)String.format("Invalid number of transmitted units", new Object[0]));
                return -1;
            }
            if (chan.fillMode == 3) {
                chan.splitPoint = this.br.read(2) + (chan.chNum << 1) + 1;
            }
        }
        return 0;
    }

    private int getDelta(int deltaBits) {
        return deltaBits <= 0 ? 0 : this.br.read(deltaBits);
    }

    private void unpackVqShape(int startVal, int[] shapeVec, int[] dst, int numValues) {
        if (numValues > 0) {
            dst[0] = startVal;
            dst[1] = startVal;
            dst[2] = startVal;
            for (int i = 3; i < numValues; ++i) {
                dst[i] = startVal - shapeVec[Atrac3plusData2.atrac3p_qu_num_to_seg[i] - 1];
            }
        }
    }

    private void unpackSfVqShape(int[] dst, int numValues) {
        int startVal = this.br.read(6);
        this.unpackVqShape(startVal, Atrac3plusData2.atrac3p_sf_shapes[this.br.read(6)], dst, numValues);
    }

    private int addWordlenWeights(Channel chan, int weightIdx) {
        int[] weigthsTab = Atrac3plusData2.atrac3p_wl_weights[chan.chNum * 3 + weightIdx - 1];
        for (int i = 0; i < this.ctx.numQuantUnits; ++i) {
            int n = i;
            chan.quWordlen[n] = chan.quWordlen[n] + weigthsTab[i];
            if (chan.quWordlen[i] >= 0 && chan.quWordlen[i] <= 7) continue;
            log.error((Object)String.format("WL index out of range pos=%d, val=%d", i, chan.quWordlen[i]));
            return -1;
        }
        return 0;
    }

    private int decodeChannelWordlen(int chNum) {
        Channel chan = this.ctx.channels[chNum];
        Channel refChan = this.ctx.channels[0];
        int weightIdx = 0;
        chan.fillMode = 0;
        switch (this.br.read(2)) {
            case 0: {
                for (int i = 0; i < this.ctx.numQuantUnits; ++i) {
                    chan.quWordlen[i] = this.br.read(3);
                }
                break;
            }
            case 1: {
                int i;
                int delta;
                int ret;
                if (chNum > 0) {
                    ret = this.numCodedUnits(chan);
                    if (ret < 0) {
                        return ret;
                    }
                    if (chan.numCodedVals <= 0) break;
                    VLC vlcTab = wl_vlc_tabs[this.br.read(2)];
                    for (int i2 = 0; i2 < chan.numCodedVals; ++i2) {
                        delta = vlcTab.getVLC2(this.br);
                        chan.quWordlen[i2] = refChan.quWordlen[i2] + delta & 7;
                    }
                } else {
                    weightIdx = this.br.read(2);
                    ret = this.numCodedUnits(chan);
                    if (ret < 0) {
                        return ret;
                    }
                    if (chan.numCodedVals <= 0) break;
                    int pos = this.br.read(5);
                    if (pos > chan.numCodedVals) {
                        log.error((Object)String.format("WL mode 1: invalid position %d", pos));
                        return -1;
                    }
                    int deltaBits = this.br.read(2);
                    int minVal = this.br.read(3);
                    for (i = 0; i < pos; ++i) {
                        chan.quWordlen[i] = this.br.read(3);
                    }
                    for (i = pos; i < chan.numCodedVals; ++i) {
                        chan.quWordlen[i] = minVal + this.getDelta(deltaBits) & 7;
                    }
                }
                break;
            }
            case 2: {
                int i;
                int ret = this.numCodedUnits(chan);
                if (ret < 0) {
                    return ret;
                }
                if (chNum > 0 && chan.numCodedVals > 0) {
                    VLC vlcTab = wl_vlc_tabs[this.br.read(2)];
                    int delta = vlcTab.getVLC2(this.br);
                    chan.quWordlen[0] = refChan.quWordlen[0] + delta & 7;
                    for (int i3 = 1; i3 < chan.numCodedVals; ++i3) {
                        int diff = refChan.quWordlen[i3] - refChan.quWordlen[i3 - 1];
                        delta = vlcTab.getVLC2(this.br);
                        chan.quWordlen[i3] = chan.quWordlen[i3 - 1] + diff + delta & 7;
                    }
                    break;
                }
                if (chan.numCodedVals <= 0) break;
                boolean flag = this.br.readBool();
                VLC vlcTab = wl_vlc_tabs[this.br.read(1)];
                int startVal = this.br.read(3);
                this.unpackVqShape(startVal, Atrac3plusData2.atrac3p_wl_shapes[startVal][this.br.read(4)], chan.quWordlen, chan.numCodedVals);
                if (!flag) {
                    for (i = 0; i < chan.numCodedVals; ++i) {
                        int delta = vlcTab.getVLC2(this.br);
                        chan.quWordlen[i] = chan.quWordlen[i] + delta & 7;
                    }
                    break;
                }
                for (i = 0; i < (chan.numCodedVals & 0xFFFFFFFE); i += 2) {
                    if (this.br.readBool()) continue;
                    chan.quWordlen[i] = chan.quWordlen[i] + vlcTab.getVLC2(this.br) & 7;
                    chan.quWordlen[i + 1] = chan.quWordlen[i + 1] + vlcTab.getVLC2(this.br) & 7;
                }
                if ((chan.numCodedVals & 1) == 0) break;
                chan.quWordlen[i] = chan.quWordlen[i] + vlcTab.getVLC2(this.br) & 7;
                break;
            }
            case 3: {
                int delta;
                weightIdx = this.br.read(2);
                int ret = this.numCodedUnits(chan);
                if (ret < 0) {
                    return ret;
                }
                if (chan.numCodedVals <= 0) break;
                VLC vlcTab = wl_vlc_tabs[this.br.read(2)];
                chan.quWordlen[0] = this.br.read(3);
                for (int i = 1; i < chan.numCodedVals; ++i) {
                    delta = vlcTab.getVLC2(this.br);
                    chan.quWordlen[i] = chan.quWordlen[i - 1] + delta & 7;
                }
                break;
            }
        }
        if (chan.fillMode == 2) {
            for (int i = chan.numCodedVals; i < this.ctx.numQuantUnits; ++i) {
                chan.quWordlen[i] = chNum > 0 ? this.br.read1() : 1;
            }
        } else if (chan.fillMode == 3) {
            int pos = chNum > 0 ? chan.numCodedVals + chan.splitPoint : this.ctx.numQuantUnits - chan.splitPoint;
            for (int i = chan.numCodedVals; i < pos; ++i) {
                chan.quWordlen[i] = 1;
            }
        }
        if (weightIdx != 0) {
            return this.addWordlenWeights(chan, weightIdx);
        }
        return 0;
    }

    private int substractSfWeights(Channel chan, int wtabIdx) {
        int[] weigthsTab = Atrac3plusData2.atrac3p_sf_weights[wtabIdx - 1];
        for (int i = 0; i < this.ctx.usedQuantUnits; ++i) {
            int n = i;
            chan.quSfIdx[n] = chan.quSfIdx[n] - weigthsTab[i];
            if (chan.quSfIdx[i] >= 0 && chan.quSfIdx[i] <= 63) continue;
            log.error((Object)String.format("SF index out of range pos=%d, val=%d", i, chan.quSfIdx[i]));
            return -1;
        }
        return 0;
    }

    private int decodeChannelSfIdx(int chNum) {
        Channel chan = this.ctx.channels[chNum];
        Channel refChan = this.ctx.channels[0];
        int weightIdx = 0;
        chan.fillMode = 0;
        switch (this.br.read(2)) {
            case 0: {
                for (int i = 0; i < this.ctx.usedQuantUnits; ++i) {
                    chan.quSfIdx[i] = this.br.read(6);
                }
                break;
            }
            case 1: {
                if (chNum > 0) {
                    VLC vlcTab = sf_vlc_tabs[this.br.read(2)];
                    for (int i = 0; i < this.ctx.usedQuantUnits; ++i) {
                        int delta = vlcTab.getVLC2(this.br);
                        chan.quSfIdx[i] = refChan.quSfIdx[i] + delta & 0x3F;
                    }
                } else {
                    weightIdx = this.br.read(2);
                    if (weightIdx == 3) {
                        int i;
                        this.unpackSfVqShape(chan.quSfIdx, this.ctx.usedQuantUnits);
                        int numLongVals = this.br.read(5);
                        int deltaBits = this.br.read(2);
                        int minVal = this.br.read(4) - 7;
                        for (i = 0; i < numLongVals; ++i) {
                            chan.quSfIdx[i] = chan.quSfIdx[i] + this.br.read(4) - 7 & 0x3F;
                        }
                        for (i = numLongVals; i < this.ctx.usedQuantUnits; ++i) {
                            chan.quSfIdx[i] = chan.quSfIdx[i] + minVal + this.getDelta(deltaBits) & 0x3F;
                        }
                    } else {
                        int i;
                        int numLongVals = this.br.read(5);
                        int deltaBits = this.br.read(3);
                        int minVal = this.br.read(6);
                        if (numLongVals > this.ctx.usedQuantUnits || deltaBits == 7) {
                            log.error((Object)String.format("SF mode 1: invalid parameters", new Object[0]));
                            return -1;
                        }
                        for (i = 0; i < numLongVals; ++i) {
                            chan.quSfIdx[i] = this.br.read(6);
                        }
                        for (i = numLongVals; i < this.ctx.usedQuantUnits; ++i) {
                            chan.quSfIdx[i] = minVal + this.getDelta(deltaBits) & 0x3F;
                        }
                    }
                }
                break;
            }
            case 2: {
                if (chNum > 0) {
                    VLC vlcTab = sf_vlc_tabs[this.br.read(2)];
                    int delta = vlcTab.getVLC2(this.br);
                    chan.quSfIdx[0] = refChan.quSfIdx[0] + delta & 0x3F;
                    for (int i = 1; i < this.ctx.usedQuantUnits; ++i) {
                        int diff = refChan.quSfIdx[i] - refChan.quSfIdx[i - 1];
                        delta = vlcTab.getVLC2(this.br);
                        chan.quSfIdx[i] = chan.quSfIdx[i - 1] + diff + delta & 0x3F;
                    }
                } else {
                    if (chan.numCodedVals <= 0) break;
                    VLC vlcTab = sf_vlc_tabs[this.br.read(2) + 4];
                    this.unpackSfVqShape(chan.quSfIdx, this.ctx.usedQuantUnits);
                    for (int i = 0; i < this.ctx.usedQuantUnits; ++i) {
                        int delta = vlcTab.getVLC2(this.br);
                        chan.quSfIdx[i] = chan.quSfIdx[i] + Utilities.signExtend(delta, 4) & 0x3F;
                    }
                }
                break;
            }
            case 3: {
                if (chNum > 0) {
                    for (int i = 0; i < this.ctx.usedQuantUnits; ++i) {
                        chan.quSfIdx[i] = refChan.quSfIdx[i];
                    }
                } else {
                    weightIdx = this.br.read(2);
                    int vlcSel = this.br.read(2);
                    VLC vlcTab = sf_vlc_tabs[vlcSel];
                    if (weightIdx == 3) {
                        vlcTab = sf_vlc_tabs[vlcSel + 4];
                        this.unpackSfVqShape(chan.quSfIdx, this.ctx.usedQuantUnits);
                        int diff = this.br.read(4) + 56 & 0x3F;
                        chan.quSfIdx[0] = chan.quSfIdx[0] + diff & 0x3F;
                        for (int i = 1; i < this.ctx.usedQuantUnits; ++i) {
                            int delta = vlcTab.getVLC2(this.br);
                            diff = diff + Utilities.signExtend(delta, 4) & 0x3F;
                            chan.quSfIdx[i] = diff + chan.quSfIdx[i] & 0x3F;
                        }
                    } else {
                        chan.quSfIdx[0] = this.br.read(6);
                        for (int i = 1; i < this.ctx.usedQuantUnits; ++i) {
                            int delta = vlcTab.getVLC2(this.br);
                            chan.quSfIdx[i] = chan.quSfIdx[i - 1] + delta & 0x3F;
                        }
                    }
                }
                break;
            }
        }
        if (weightIdx != 0 && weightIdx < 3) {
            return this.substractSfWeights(chan, weightIdx);
        }
        return 0;
    }

    private int decodeQuantWordlen() {
        int i;
        for (int chNum = 0; chNum < this.numChannels; ++chNum) {
            Arrays.fill(this.ctx.channels[chNum].quWordlen, 0);
            int ret = this.decodeChannelWordlen(chNum);
            if (ret >= 0) continue;
            return ret;
        }
        for (i = this.ctx.numQuantUnits - 1; i >= 0 && this.ctx.channels[0].quWordlen[i] == 0 && (this.numChannels != 2 || this.ctx.channels[1].quWordlen[i] == 0); --i) {
        }
        this.ctx.usedQuantUnits = i + 1;
        return 0;
    }

    private int decodeScaleFactors() {
        if (this.ctx.usedQuantUnits == 0) {
            return 0;
        }
        for (int chNum = 0; chNum < this.numChannels; ++chNum) {
            Arrays.fill(this.ctx.channels[chNum].quSfIdx, 0);
            int ret = this.decodeChannelSfIdx(chNum);
            if (ret >= 0) continue;
            return ret;
        }
        return 0;
    }

    private int getNumCtValues() {
        if (!this.br.readBool()) {
            return this.ctx.usedQuantUnits;
        }
        int numCodedVals = this.br.read(5);
        if (numCodedVals > this.ctx.usedQuantUnits) {
            log.error((Object)String.format("Invalid number of code table indexes: %d", numCodedVals));
            return -1;
        }
        return numCodedVals;
    }

    private int decodeChannelCodeTab(int chNum) {
        int mask = this.ctx.useFullTable ? 7 : 3;
        Channel chan = this.ctx.channels[chNum];
        Channel refChan = this.ctx.channels[0];
        chan.tableType = this.br.read(1);
        switch (this.br.read(2)) {
            case 0: {
                int numBits = this.ctx.useFullTable ? 3 : 2;
                int numVals = this.getNumCtValues();
                if (numVals < 0) {
                    return numVals;
                }
                for (int i = 0; i < numVals; ++i) {
                    if (chan.quWordlen[i] != 0) {
                        chan.quTabIdx[i] = this.br.read(numBits);
                        continue;
                    }
                    if (chNum <= 0 || refChan.quWordlen[i] == 0) continue;
                    chan.quTabIdx[i] = this.br.read1();
                }
                break;
            }
            case 1: {
                VLC vlcTab = this.ctx.useFullTable ? ct_vlc_tabs[1] : ct_vlc_tabs[0];
                int numVals = this.getNumCtValues();
                if (numVals < 0) {
                    return numVals;
                }
                for (int i = 0; i < numVals; ++i) {
                    if (chan.quWordlen[i] != 0) {
                        chan.quTabIdx[i] = vlcTab.getVLC2(this.br);
                        continue;
                    }
                    if (chNum <= 0 || refChan.quWordlen[i] == 0) continue;
                    chan.quTabIdx[i] = this.br.read1();
                }
                break;
            }
            case 2: {
                VLC deltaVlc;
                VLC vlcTab;
                if (this.ctx.useFullTable) {
                    vlcTab = ct_vlc_tabs[1];
                    deltaVlc = ct_vlc_tabs[2];
                } else {
                    vlcTab = ct_vlc_tabs[0];
                    deltaVlc = ct_vlc_tabs[0];
                }
                int pred = 0;
                int numVals = this.getNumCtValues();
                if (numVals < 0) {
                    return numVals;
                }
                for (int i = 0; i < numVals; ++i) {
                    if (chan.quWordlen[i] != 0) {
                        chan.quTabIdx[i] = i == 0 ? vlcTab.getVLC2(this.br) : pred + deltaVlc.getVLC2(this.br) & mask;
                        pred = chan.quTabIdx[i];
                        continue;
                    }
                    if (chNum <= 0 || refChan.quWordlen[i] == 0) continue;
                    chan.quTabIdx[i] = this.br.read1();
                }
                break;
            }
            case 3: {
                if (chNum <= 0) break;
                VLC vlcTab = this.ctx.useFullTable ? ct_vlc_tabs[3] : ct_vlc_tabs[0];
                int numVals = this.getNumCtValues();
                if (numVals < 0) {
                    return numVals;
                }
                for (int i = 0; i < numVals; ++i) {
                    if (chan.quWordlen[i] != 0) {
                        chan.quTabIdx[i] = refChan.quTabIdx[i] + vlcTab.getVLC2(this.br) & mask;
                        continue;
                    }
                    if (chNum <= 0 || refChan.quWordlen[i] == 0) continue;
                    chan.quTabIdx[i] = this.br.read1();
                }
                break;
            }
        }
        return 0;
    }

    private int decodeCodeTableIndexes() {
        if (this.ctx.usedQuantUnits == 0) {
            return 0;
        }
        this.ctx.useFullTable = this.br.readBool();
        for (int chNum = 0; chNum < this.numChannels; ++chNum) {
            Arrays.fill(this.ctx.channels[chNum].quTabIdx, 0);
            int ret = this.decodeChannelCodeTab(chNum);
            if (ret >= 0) continue;
            return ret;
        }
        return 0;
    }

    private void decodeQuSpectra(Atrac3plusData1.Atrac3pSpecCodeTab tab, VLC vlcTab, int[] out, int outOffset, int numSpecs) {
        int groupSize = tab.groupSize;
        int numCoeffs = tab.numCoeffs;
        int bits = tab.bits;
        boolean isSigned = tab.isSigned;
        int mask = (1 << bits) - 1;
        int pos = 0;
        while (pos < numSpecs) {
            if (groupSize == 1 || this.br.readBool()) {
                for (int j = 0; j < groupSize; ++j) {
                    int val = vlcTab.getVLC2(this.br);
                    for (int i = 0; i < numCoeffs; ++i) {
                        int cf = val & mask;
                        if (isSigned) {
                            cf = Utilities.signExtend(cf, bits);
                        } else if (cf != 0 && this.br.readBool()) {
                            cf = -cf;
                        }
                        out[outOffset + pos] = cf;
                        ++pos;
                        val >>= bits;
                    }
                }
                continue;
            }
            pos += groupSize * numCoeffs;
        }
    }

    private void decodeSpectrum() {
        for (int chNum = 0; chNum < this.numChannels; ++chNum) {
            Channel chan = this.ctx.channels[chNum];
            Arrays.fill(chan.spectrum, 0);
            Arrays.fill(chan.powerLevs, 15);
            for (int qu = 0; qu < this.ctx.usedQuantUnits; ++qu) {
                int numSpecs = Atrac3plusDsp.ff_atrac3p_qu_to_spec_pos[qu + 1] - Atrac3plusDsp.ff_atrac3p_qu_to_spec_pos[qu];
                int wordlen = chan.quWordlen[qu];
                int codetab = chan.quTabIdx[qu];
                if (wordlen > 0) {
                    if (!this.ctx.useFullTable) {
                        codetab = Atrac3plusData2.atrac3p_ct_restricted_to_full[chan.tableType][wordlen - 1][codetab];
                    }
                    int tabIndex = (chan.tableType * 8 + codetab) * 7 + wordlen - 1;
                    Atrac3plusData1.Atrac3pSpecCodeTab tab = Atrac3plusData1.atrac3p_spectra_tabs[tabIndex];
                    if (tab.redirect >= 0) {
                        tabIndex = tab.redirect;
                    }
                    this.decodeQuSpectra(tab, spec_vlc_tabs[tabIndex], chan.spectrum, Atrac3plusDsp.ff_atrac3p_qu_to_spec_pos[qu], numSpecs);
                    continue;
                }
                if (chNum <= 0 || this.ctx.channels[0].quWordlen[qu] == 0 || codetab != 0) continue;
                System.arraycopy(this.ctx.channels[0].spectrum, Atrac3plusDsp.ff_atrac3p_qu_to_spec_pos[qu], chan.spectrum, Atrac3plusDsp.ff_atrac3p_qu_to_spec_pos[qu], numSpecs);
                chan.quWordlen[qu] = this.ctx.channels[0].quWordlen[qu];
            }
            if (this.ctx.usedQuantUnits <= 2) continue;
            int numSpecs = Atrac3plusData2.atrac3p_subband_to_num_powgrps[this.ctx.numCodedSubbands - 1];
            for (int i = 0; i < numSpecs; ++i) {
                chan.powerLevs[i] = this.br.read(4);
            }
        }
    }

    private boolean getSubbandFlags(boolean[] out, int numFlags) {
        boolean result = this.br.readBool();
        if (result) {
            if (this.br.readBool()) {
                for (int i = 0; i < numFlags; ++i) {
                    out[i] = this.br.readBool();
                }
            } else {
                for (int i = 0; i < numFlags; ++i) {
                    out[i] = true;
                }
            }
        } else {
            for (int i = 0; i < numFlags; ++i) {
                out[i] = false;
            }
        }
        return result;
    }

    private void decodeWindowShape() {
        for (int i = 0; i < this.numChannels; ++i) {
            this.getSubbandFlags(this.ctx.channels[i].wndShape, this.ctx.numSubbands);
        }
    }

    private int decodeGaincNPoints(int chNum, int codedSubbands) {
        Channel chan = this.ctx.channels[chNum];
        Channel refChan = this.ctx.channels[0];
        switch (this.br.read(2)) {
            case 0: {
                for (int i = 0; i < codedSubbands; ++i) {
                    chan.gainData[i].numPoints = this.br.read(3);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < codedSubbands; ++i) {
                    chan.gainData[i].numPoints = gain_vlc_tabs[0].getVLC2(this.br);
                }
                break;
            }
            case 2: {
                if (chNum > 0) {
                    for (int i = 0; i < codedSubbands; ++i) {
                        int delta = gain_vlc_tabs[1].getVLC2(this.br);
                        chan.gainData[i].numPoints = refChan.gainData[i].numPoints + delta & 7;
                    }
                } else {
                    chan.gainData[0].numPoints = gain_vlc_tabs[0].getVLC2(this.br);
                    for (int i = 1; i < codedSubbands; ++i) {
                        int delta = gain_vlc_tabs[1].getVLC2(this.br);
                        chan.gainData[i].numPoints = chan.gainData[i - 1].numPoints + delta & 7;
                    }
                }
                break;
            }
            case 3: {
                if (chNum > 0) {
                    for (int i = 0; i < codedSubbands; ++i) {
                        chan.gainData[i].numPoints = refChan.gainData[i].numPoints;
                    }
                } else {
                    int deltaBits = this.br.read(2);
                    int minVal = this.br.read(3);
                    for (int i = 0; i < codedSubbands; ++i) {
                        chan.gainData[i].numPoints = minVal + this.getDelta(deltaBits);
                        if (chan.gainData[i].numPoints <= 7) continue;
                        return -1;
                    }
                }
                break;
            }
        }
        return 0;
    }

    private void gaincLevelMode1m(AtracGainInfo dst) {
        if (dst.numPoints > 0) {
            dst.levCode[0] = gain_vlc_tabs[2].getVLC2(this.br);
        }
        for (int i = 1; i < dst.numPoints; ++i) {
            int delta = gain_vlc_tabs[3].getVLC2(this.br);
            dst.levCode[i] = dst.levCode[i - 1] + delta & 0xF;
        }
    }

    private void gaincLevelMode3s(AtracGainInfo dst, AtracGainInfo ref) {
        for (int i = 0; i < dst.numPoints; ++i) {
            dst.levCode[i] = i >= ref.numPoints ? 7 : ref.levCode[i];
        }
    }

    private int decodeGaincLevels(int chNum, int codedSubbands) {
        Channel chan = this.ctx.channels[chNum];
        Channel refChan = this.ctx.channels[0];
        switch (this.br.read(2)) {
            case 0: {
                for (int sb = 0; sb < codedSubbands; ++sb) {
                    for (int i = 0; i < chan.gainData[sb].numPoints; ++i) {
                        chan.gainData[sb].levCode[i] = this.br.read(4);
                    }
                }
                break;
            }
            case 1: {
                if (chNum > 0) {
                    for (int sb = 0; sb < codedSubbands; ++sb) {
                        for (int i = 0; i < chan.gainData[sb].numPoints; ++i) {
                            int delta = gain_vlc_tabs[5].getVLC2(this.br);
                            int pred = i >= refChan.gainData[sb].numPoints ? 7 : refChan.gainData[sb].levCode[i];
                            chan.gainData[sb].levCode[i] = pred + delta & 0xF;
                        }
                    }
                } else {
                    for (int sb = 0; sb < codedSubbands; ++sb) {
                        this.gaincLevelMode1m(chan.gainData[sb]);
                    }
                }
                break;
            }
            case 2: {
                if (chNum > 0) {
                    for (int sb = 0; sb < codedSubbands; ++sb) {
                        if (chan.gainData[sb].numPoints <= 0) continue;
                        if (this.br.readBool()) {
                            this.gaincLevelMode1m(chan.gainData[sb]);
                            continue;
                        }
                        this.gaincLevelMode3s(chan.gainData[sb], refChan.gainData[sb]);
                    }
                } else {
                    if (chan.gainData[0].numPoints > 0) {
                        this.gaincLevelMode1m(chan.gainData[0]);
                    }
                    for (int sb = 1; sb < codedSubbands; ++sb) {
                        for (int i = 0; i < chan.gainData[sb].numPoints; ++i) {
                            int delta = gain_vlc_tabs[4].getVLC2(this.br);
                            int pred = i >= chan.gainData[sb - 1].numPoints ? 7 : chan.gainData[sb - 1].levCode[i];
                            chan.gainData[sb].levCode[i] = pred + delta & 0xF;
                        }
                    }
                }
                break;
            }
            case 3: {
                if (chNum > 0) {
                    for (int sb = 0; sb < codedSubbands; ++sb) {
                        this.gaincLevelMode3s(chan.gainData[sb], refChan.gainData[sb]);
                    }
                } else {
                    int deltaBits = this.br.read(2);
                    int minVal = this.br.read(4);
                    for (int sb = 0; sb < codedSubbands; ++sb) {
                        for (int i = 0; i < chan.gainData[sb].numPoints; ++i) {
                            chan.gainData[sb].levCode[i] = minVal + this.getDelta(deltaBits);
                            if (chan.gainData[sb].levCode[i] <= 15) continue;
                            return -1;
                        }
                    }
                }
                break;
            }
        }
        return 0;
    }

    private void gaincLocMode0(AtracGainInfo dst, int pos) {
        if (pos == 0 || dst.locCode[pos - 1] < 15) {
            dst.locCode[pos] = this.br.read(5);
        } else if (dst.locCode[pos - 1] >= 30) {
            dst.locCode[pos] = 31;
        } else {
            int deltaBits = CodecUtils.avLog2(30 - dst.locCode[pos - 1]) + 1;
            dst.locCode[pos] = dst.locCode[pos - 1] + this.br.read(deltaBits) + 1;
        }
    }

    private void gaincLocMode1(AtracGainInfo dst) {
        if (dst.numPoints > 0) {
            dst.locCode[0] = this.br.read(5);
            for (int i = 1; i < dst.numPoints; ++i) {
                VLC tab = dst.levCode[i] <= dst.levCode[i - 1] ? gain_vlc_tabs[7] : gain_vlc_tabs[9];
                dst.locCode[i] = dst.locCode[i - 1] + tab.getVLC2(this.br);
            }
        }
    }

    private int decodeGaincLocCodes(int chNum, int codedSubbands) {
        int sb;
        Channel chan = this.ctx.channels[chNum];
        Channel refChan = this.ctx.channels[0];
        int codingMode = this.br.read(2);
        switch (codingMode) {
            case 0: {
                for (sb = 0; sb < codedSubbands; ++sb) {
                    for (int i = 0; i < chan.gainData[sb].numPoints; ++i) {
                        this.gaincLocMode0(chan.gainData[sb], i);
                    }
                }
                break;
            }
            case 1: {
                if (chNum > 0) {
                    for (sb = 0; sb < codedSubbands; ++sb) {
                        if (chan.gainData[sb].numPoints <= 0) continue;
                        AtracGainInfo dst = chan.gainData[sb];
                        AtracGainInfo ref = refChan.gainData[sb];
                        int delta = gain_vlc_tabs[10].getVLC2(this.br);
                        int pred = ref.numPoints > 0 ? ref.locCode[0] : 0;
                        dst.locCode[0] = pred + delta & 0x1F;
                        for (int i = 1; i < dst.numPoints; ++i) {
                            boolean moreThanRef;
                            boolean bl = moreThanRef = i >= ref.numPoints;
                            if (dst.levCode[i] > dst.levCode[i - 1]) {
                                if (moreThanRef) {
                                    delta = gain_vlc_tabs[9].getVLC2(this.br);
                                    dst.locCode[i] = dst.locCode[i - 1] + delta;
                                    continue;
                                }
                                if (this.br.readBool()) {
                                    this.gaincLocMode0(dst, i);
                                    continue;
                                }
                                dst.locCode[i] = ref.locCode[i];
                                continue;
                            }
                            VLC tab = moreThanRef ? gain_vlc_tabs[7] : gain_vlc_tabs[10];
                            delta = tab.getVLC2(this.br);
                            dst.locCode[i] = moreThanRef ? dst.locCode[i - 1] + delta : ref.locCode[i] + delta & 0x1F;
                        }
                    }
                } else {
                    for (sb = 0; sb < codedSubbands; ++sb) {
                        this.gaincLocMode1(chan.gainData[sb]);
                    }
                }
                break;
            }
            case 2: {
                int i;
                if (chNum > 0) {
                    for (sb = 0; sb < codedSubbands; ++sb) {
                        if (chan.gainData[sb].numPoints <= 0) continue;
                        AtracGainInfo dst = chan.gainData[sb];
                        AtracGainInfo ref = refChan.gainData[sb];
                        if (dst.numPoints > ref.numPoints || this.br.readBool()) {
                            this.gaincLocMode1(dst);
                            continue;
                        }
                        for (i = 0; i < chan.gainData[sb].numPoints; ++i) {
                            dst.locCode[i] = ref.locCode[i];
                        }
                    }
                } else {
                    for (int i2 = 0; i2 < chan.gainData[0].numPoints; ++i2) {
                        this.gaincLocMode0(chan.gainData[0], i2);
                    }
                    for (sb = 1; sb < codedSubbands; ++sb) {
                        if (chan.gainData[sb].numPoints <= 0) continue;
                        AtracGainInfo dst = chan.gainData[sb];
                        int delta = gain_vlc_tabs[6].getVLC2(this.br);
                        int pred = chan.gainData[sb - 1].numPoints > 0 ? chan.gainData[sb - 1].locCode[0] : 0;
                        dst.locCode[0] = pred + delta & 0x1F;
                        for (int i3 = 1; i3 < dst.numPoints; ++i3) {
                            boolean moreThanRef = i3 >= chan.gainData[sb - 1].numPoints;
                            VLC tab = gain_vlc_tabs[(dst.levCode[i3] > dst.levCode[i3 - 1] ? 2 : 0) + (moreThanRef ? 1 : 0) + 6];
                            delta = tab.getVLC2(this.br);
                            dst.locCode[i3] = moreThanRef ? dst.locCode[i3 - 1] + delta : chan.gainData[sb - 1].locCode[i3] + delta & 0x1F;
                        }
                    }
                }
                break;
            }
            case 3: {
                int i;
                if (chNum > 0) {
                    for (sb = 0; sb < codedSubbands; ++sb) {
                        for (int i4 = 0; i4 < chan.gainData[sb].numPoints; ++i4) {
                            if (i4 >= refChan.gainData[sb].numPoints) {
                                this.gaincLocMode0(chan.gainData[sb], i4);
                                continue;
                            }
                            chan.gainData[sb].locCode[i4] = refChan.gainData[sb].locCode[i4];
                        }
                    }
                } else {
                    int deltaBits = this.br.read(2) + 1;
                    int minVal = this.br.read(5);
                    for (int sb2 = 0; sb2 < codedSubbands; ++sb2) {
                        for (i = 0; i < chan.gainData[sb2].numPoints; ++i) {
                            chan.gainData[sb2].locCode[i] = minVal + i + this.br.read(deltaBits);
                        }
                    }
                }
                break;
            }
        }
        for (sb = 0; sb < codedSubbands; ++sb) {
            AtracGainInfo dst = chan.gainData[sb];
            for (int i = 0; i < chan.gainData[sb].numPoints; ++i) {
                if (dst.locCode[i] >= 0 && dst.locCode[i] <= 31 && (i <= 0 || dst.locCode[i] > dst.locCode[i - 1])) continue;
                log.error((Object)String.format("Invalid gain location: ch=%d, sb=%d, pos=%d, val=%d", chNum, sb, i, dst.locCode[i]));
                return -1;
            }
        }
        return 0;
    }

    private int decodeGaincData() {
        for (int chNum = 0; chNum < this.numChannels; ++chNum) {
            for (int i = 0; i < 16; ++i) {
                this.ctx.channels[chNum].gainData[i].clear();
            }
            if (this.br.readBool()) {
                int codedSubbands = this.br.read(4) + 1;
                this.ctx.channels[chNum].numGainSubbands = this.br.readBool() ? this.br.read(4) + 1 : codedSubbands;
                int ret = this.decodeGaincNPoints(chNum, codedSubbands);
                if (ret < 0) {
                    return ret;
                }
                ret = this.decodeGaincLevels(chNum, codedSubbands);
                if (ret < 0) {
                    return ret;
                }
                ret = this.decodeGaincLocCodes(chNum, codedSubbands);
                if (ret < 0) {
                    return ret;
                }
                if (codedSubbands <= 0) continue;
                for (int sb = codedSubbands; sb < this.ctx.channels[chNum].numGainSubbands; ++sb) {
                    this.ctx.channels[chNum].gainData[sb].copy(this.ctx.channels[chNum].gainData[sb - 1]);
                }
                continue;
            }
            this.ctx.channels[chNum].numGainSubbands = 0;
        }
        return 0;
    }

    private void decodeTonesEnvelope(int chNum, boolean[] bandHasTones) {
        WavesData[] dst = this.ctx.channels[chNum].tonesInfo;
        WavesData[] ref = this.ctx.channels[0].tonesInfo;
        if (chNum == 0 || !this.br.readBool()) {
            for (int sb = 0; sb < this.ctx.wavesInfo.numToneBands; ++sb) {
                if (!bandHasTones[sb]) continue;
                dst[sb].pendEnv.hasStartPoint = this.br.readBool();
                dst[sb].pendEnv.startPos = dst[sb].pendEnv.hasStartPoint ? this.br.read(5) : -1;
                dst[sb].pendEnv.hasStopPoint = this.br.readBool();
                dst[sb].pendEnv.stopPos = dst[sb].pendEnv.hasStopPoint ? this.br.read(5) : 32;
            }
        } else {
            for (int sb = 0; sb < this.ctx.wavesInfo.numToneBands; ++sb) {
                if (!bandHasTones[sb]) continue;
                dst[sb].pendEnv.copy(ref[sb].pendEnv);
            }
        }
    }

    private int decodeBandNumwavs(int chNum, boolean[] bandHasTones) {
        int sb;
        WavesData[] dst = this.ctx.channels[chNum].tonesInfo;
        WavesData[] ref = this.ctx.channels[0].tonesInfo;
        int mode = this.br.read(chNum + 1);
        switch (mode) {
            case 0: {
                for (sb = 0; sb < this.ctx.wavesInfo.numToneBands; ++sb) {
                    if (!bandHasTones[sb]) continue;
                    dst[sb].numWavs = this.br.read(4);
                }
                break;
            }
            case 1: {
                for (sb = 0; sb < this.ctx.wavesInfo.numToneBands; ++sb) {
                    if (!bandHasTones[sb]) continue;
                    dst[sb].numWavs = tone_vlc_tabs[1].getVLC2(this.br);
                }
                break;
            }
            case 2: {
                for (sb = 0; sb < this.ctx.wavesInfo.numToneBands; ++sb) {
                    if (!bandHasTones[sb]) continue;
                    int delta = tone_vlc_tabs[2].getVLC2(this.br);
                    delta = Utilities.signExtend(delta, 3);
                    dst[sb].numWavs = ref[sb].numWavs + delta & 0xF;
                }
                break;
            }
            case 3: {
                for (sb = 0; sb < this.ctx.wavesInfo.numToneBands; ++sb) {
                    if (!bandHasTones[sb]) continue;
                    dst[sb].numWavs = ref[sb].numWavs;
                }
                break;
            }
        }
        for (sb = 0; sb < this.ctx.wavesInfo.numToneBands; ++sb) {
            if (!bandHasTones[sb]) continue;
            if (this.ctx.wavesInfo.tonesIndex + dst[sb].numWavs > 48) {
                log.error((Object)String.format("Too many tones: %d (max. 48)", this.ctx.wavesInfo.tonesIndex + dst[sb].numWavs));
                return -1;
            }
            dst[sb].startIndex = this.ctx.wavesInfo.tonesIndex;
            this.ctx.wavesInfo.tonesIndex += dst[sb].numWavs;
        }
        return 0;
    }

    private void decodeTonesFrequency(int chNum, boolean[] bandHasTones) {
        WavesData[] dst = this.ctx.channels[chNum].tonesInfo;
        WavesData[] ref = this.ctx.channels[0].tonesInfo;
        if (chNum == 0 || !this.br.readBool()) {
            for (int sb = 0; sb < this.ctx.wavesInfo.numToneBands; ++sb) {
                int nbits;
                int i;
                boolean direction;
                if (!bandHasTones[sb] || dst[sb].numWavs == 0) continue;
                int iwav = dst[sb].startIndex;
                boolean bl = direction = dst[sb].numWavs > 1 ? this.br.readBool() : false;
                if (direction) {
                    if (dst[sb].numWavs > 0) {
                        this.ctx.wavesInfo.waves[iwav + dst[sb].numWavs - 1].freqIndex = this.br.read(10);
                    }
                    for (i = dst[sb].numWavs - 2; i >= 0; --i) {
                        nbits = CodecUtils.avLog2(this.ctx.wavesInfo.waves[iwav + i + 1].freqIndex) + 1;
                        this.ctx.wavesInfo.waves[iwav + i].freqIndex = this.br.read(nbits);
                    }
                    continue;
                }
                for (i = 0; i < dst[sb].numWavs; ++i) {
                    if (i == 0 || this.ctx.wavesInfo.waves[iwav + i - 1].freqIndex < 512) {
                        this.ctx.wavesInfo.waves[iwav + i].freqIndex = this.br.read(10);
                        continue;
                    }
                    nbits = CodecUtils.avLog2(1023 - this.ctx.wavesInfo.waves[iwav + i - 1].freqIndex) + 1;
                    this.ctx.wavesInfo.waves[iwav + i].freqIndex = this.br.read(nbits) + 1024 - (1 << nbits);
                }
            }
        } else {
            for (int sb = 0; sb < this.ctx.wavesInfo.numToneBands; ++sb) {
                if (!bandHasTones[sb] || dst[sb].numWavs == 0) continue;
                int iwav = ref[sb].startIndex;
                int owav = dst[sb].startIndex;
                for (int i = 0; i < dst[sb].numWavs; ++i) {
                    int delta = tone_vlc_tabs[6].getVLC2(this.br);
                    delta = Utilities.signExtend(delta, 8);
                    int pred = i < ref[sb].numWavs ? this.ctx.wavesInfo.waves[iwav + i].freqIndex : (ref[sb].numWavs > 0 ? this.ctx.wavesInfo.waves[iwav + ref[sb].numWavs - 1].freqIndex : 0);
                    this.ctx.wavesInfo.waves[owav + i].freqIndex = pred + delta & 0x3FF;
                }
            }
        }
    }

    private void decodeTonesAmplitude(int chNum, boolean[] bandHasTones) {
        WavesData[] dst = this.ctx.channels[chNum].tonesInfo;
        WavesData[] ref = this.ctx.channels[0].tonesInfo;
        int[] refwaves = new int[48];
        if (chNum > 0) {
            for (int sb = 0; sb < this.ctx.wavesInfo.numToneBands; ++sb) {
                if (!bandHasTones[sb] || dst[sb].numWavs == 0) continue;
                int wsrc = dst[sb].startIndex;
                int wref = ref[sb].startIndex;
                for (int j = 0; j < dst[sb].numWavs; ++j) {
                    int fi = 0;
                    int maxdiff = 1024;
                    for (int i = 0; i < ref[sb].numWavs; ++i) {
                        int diff = Math.abs(this.ctx.wavesInfo.waves[wsrc + j].freqIndex - this.ctx.wavesInfo.waves[wref + i].freqIndex);
                        if (diff >= maxdiff) continue;
                        maxdiff = diff;
                        fi = i;
                    }
                    refwaves[dst[sb].startIndex + j] = maxdiff < 8 ? fi + ref[sb].startIndex : (j < ref[sb].numWavs ? j + ref[sb].startIndex : -1);
                }
            }
        }
        int mode = this.br.read(chNum + 1);
        switch (mode) {
            case 0: {
                int i;
                int sb;
                for (sb = 0; sb < this.ctx.wavesInfo.numToneBands; ++sb) {
                    if (!bandHasTones[sb] || dst[sb].numWavs == 0) continue;
                    if (this.ctx.wavesInfo.amplitudeMode != 0) {
                        for (i = 0; i < dst[sb].numWavs; ++i) {
                            this.ctx.wavesInfo.waves[dst[sb].startIndex + i].ampSf = this.br.read(6);
                        }
                        continue;
                    }
                    this.ctx.wavesInfo.waves[dst[sb].startIndex].ampSf = this.br.read(6);
                }
                break;
            }
            case 1: {
                int i;
                int sb;
                for (sb = 0; sb < this.ctx.wavesInfo.numToneBands; ++sb) {
                    if (!bandHasTones[sb] || dst[sb].numWavs == 0) continue;
                    if (this.ctx.wavesInfo.amplitudeMode != 0) {
                        for (i = 0; i < dst[sb].numWavs; ++i) {
                            this.ctx.wavesInfo.waves[dst[sb].startIndex + i].ampSf = tone_vlc_tabs[3].getVLC2(this.br) + 20;
                        }
                        continue;
                    }
                    this.ctx.wavesInfo.waves[dst[sb].startIndex].ampSf = tone_vlc_tabs[4].getVLC2(this.br) + 24;
                }
                break;
            }
            case 2: {
                int i;
                int sb;
                for (sb = 0; sb < this.ctx.wavesInfo.numToneBands; ++sb) {
                    if (!bandHasTones[sb] || dst[sb].numWavs == 0) continue;
                    for (i = 0; i < dst[sb].numWavs; ++i) {
                        int delta = tone_vlc_tabs[5].getVLC2(this.br);
                        delta = Utilities.signExtend(delta, 5);
                        int pred = refwaves[dst[sb].startIndex + i] >= 0 ? this.ctx.wavesInfo.waves[refwaves[dst[sb].startIndex + i]].ampSf : 34;
                        this.ctx.wavesInfo.waves[dst[sb].startIndex + i].ampSf = pred + delta & 0x3F;
                    }
                }
                break;
            }
            case 3: {
                int i;
                int sb;
                for (sb = 0; sb < this.ctx.wavesInfo.numToneBands; ++sb) {
                    if (!bandHasTones[sb]) continue;
                    for (i = 0; i < dst[sb].numWavs; ++i) {
                        this.ctx.wavesInfo.waves[dst[sb].startIndex + i].ampSf = refwaves[dst[sb].startIndex + i] >= 0 ? this.ctx.wavesInfo.waves[refwaves[dst[sb].startIndex + i]].ampSf : 32;
                    }
                }
                break;
            }
        }
    }

    private void decodeTonesPhase(int chNum, boolean[] bandHasTones) {
        WavesData[] dst = this.ctx.channels[chNum].tonesInfo;
        for (int sb = 0; sb < this.ctx.wavesInfo.numToneBands; ++sb) {
            if (!bandHasTones[sb]) continue;
            int wparam = dst[sb].startIndex;
            for (int i = 0; i < dst[sb].numWavs; ++i) {
                this.ctx.wavesInfo.waves[wparam + i].phaseIndex = this.br.read(5);
            }
        }
    }

    private int decodeTonesInfo() {
        int i;
        int chNum;
        for (chNum = 0; chNum < this.numChannels; ++chNum) {
            for (int i2 = 0; i2 < 16; ++i2) {
                this.ctx.channels[chNum].tonesInfo[i2].clear();
            }
        }
        this.ctx.wavesInfo.tonesPresent = this.br.readBool();
        if (!this.ctx.wavesInfo.tonesPresent) {
            return 0;
        }
        for (i = 0; i < this.ctx.wavesInfo.waves.length; ++i) {
            this.ctx.wavesInfo.waves[i].clear();
        }
        this.ctx.wavesInfo.amplitudeMode = this.br.read1();
        if (this.ctx.wavesInfo.amplitudeMode == 0) {
            log.error((Object)String.format("GHA amplitude mode 0", new Object[0]));
            return -1;
        }
        this.ctx.wavesInfo.numToneBands = tone_vlc_tabs[0].getVLC2(this.br) + 1;
        if (this.numChannels == 2) {
            this.getSubbandFlags(this.ctx.wavesInfo.toneSharing, this.ctx.wavesInfo.numToneBands);
            this.getSubbandFlags(this.ctx.wavesInfo.toneMaster, this.ctx.wavesInfo.numToneBands);
            if (this.getSubbandFlags(this.ctx.wavesInfo.phaseShift, this.ctx.wavesInfo.numToneBands)) {
                log.warn((Object)String.format("GHA Phase shifting", new Object[0]));
            }
        }
        this.ctx.wavesInfo.tonesIndex = 0;
        for (chNum = 0; chNum < this.numChannels; ++chNum) {
            boolean[] bandHasTones = new boolean[16];
            for (int i3 = 0; i3 < this.ctx.wavesInfo.numToneBands; ++i3) {
                bandHasTones[i3] = chNum == 0 ? true : !this.ctx.wavesInfo.toneSharing[i3];
            }
            this.decodeTonesEnvelope(chNum, bandHasTones);
            int ret = this.decodeBandNumwavs(chNum, bandHasTones);
            if (ret < 0) {
                return ret;
            }
            this.decodeTonesFrequency(chNum, bandHasTones);
            this.decodeTonesAmplitude(chNum, bandHasTones);
            this.decodeTonesPhase(chNum, bandHasTones);
        }
        if (this.numChannels == 2) {
            for (i = 0; i < this.ctx.wavesInfo.numToneBands; ++i) {
                if (this.ctx.wavesInfo.toneSharing[i]) {
                    this.ctx.channels[1].tonesInfo[i].copy(this.ctx.channels[0].tonesInfo[i]);
                }
                if (!this.ctx.wavesInfo.toneMaster[i]) continue;
                WavesData tmp = new WavesData();
                tmp.copy(this.ctx.channels[0].tonesInfo[i]);
                this.ctx.channels[0].tonesInfo[i].copy(this.ctx.channels[1].tonesInfo[i]);
                this.ctx.channels[1].tonesInfo[i].copy(tmp);
            }
        }
        return 0;
    }

    public void decodeResidualSpectrum(float[][] out) {
        int sb;
        int[] sbRNGindex = new int[16];
        if (this.ctx.muteFlag) {
            for (int ch = 0; ch < this.numChannels; ++ch) {
                Arrays.fill(out[ch], 0.0f);
            }
            return;
        }
        int RNGindex = 0;
        for (int qu = 0; qu < this.ctx.usedQuantUnits; ++qu) {
            RNGindex += this.ctx.channels[0].quSfIdx[qu] + this.ctx.channels[1].quSfIdx[qu];
        }
        int sb2 = 0;
        while (sb2 < this.ctx.numCodedSubbands) {
            sbRNGindex[sb2] = RNGindex & 0x3FC;
            ++sb2;
            RNGindex += 128;
        }
        for (int ch = 0; ch < this.numChannels; ++ch) {
            Arrays.fill(out[ch], 0, 2048, 0.0f);
            for (int qu = 0; qu < this.ctx.usedQuantUnits; ++qu) {
                int src = Atrac3plusDsp.ff_atrac3p_qu_to_spec_pos[qu];
                int dst = Atrac3plusDsp.ff_atrac3p_qu_to_spec_pos[qu];
                int nspeclines = Atrac3plusDsp.ff_atrac3p_qu_to_spec_pos[qu + 1] - Atrac3plusDsp.ff_atrac3p_qu_to_spec_pos[qu];
                if (this.ctx.channels[ch].quWordlen[qu] <= 0) continue;
                float q = Atrac3plusDsp.ff_atrac3p_sf_tab[this.ctx.channels[ch].quSfIdx[qu]] * Atrac3plusDsp.ff_atrac3p_mant_tab[this.ctx.channels[ch].quWordlen[qu]];
                for (int i = 0; i < nspeclines; ++i) {
                    out[ch][dst + i] = (float)this.ctx.channels[ch].spectrum[src + i] * q;
                }
            }
            for (sb = 0; sb < this.ctx.numCodedSubbands; ++sb) {
                this.dsp.powerCompensation(this.ctx, ch, out[ch], sbRNGindex[sb], sb);
            }
        }
        if (this.ctx.unitType == 1) {
            float[] tmp = new float[128];
            for (sb = 0; sb < this.ctx.numCodedSubbands; ++sb) {
                if (this.ctx.swapChannels[sb]) {
                    System.arraycopy(out[0], sb * 128, tmp, 0, 128);
                    System.arraycopy(out[1], sb * 128, out[0], sb * 128, 128);
                    System.arraycopy(tmp, 0, out[1], sb * 128, 128);
                }
                if (!this.ctx.negateCoeffs[sb]) continue;
                for (int i = 0; i < 128; ++i) {
                    out[1][sb * 128 + i] = -out[1][sb * 128 + i];
                }
            }
        }
    }

    public void reconstructFrame(Context at3pContext) {
        int ch;
        for (ch = 0; ch < this.numChannels; ++ch) {
            int sb;
            for (sb = 0; sb < this.ctx.numSubbands; ++sb) {
                this.dsp.imdct(at3pContext.mdctCtx, at3pContext.samples[ch], sb * 128, at3pContext.mdctBuf[ch], sb * 128, (this.ctx.channels[ch].wndShapePrev[sb] ? 2 : 0) + (this.ctx.channels[ch].wndShape[sb] ? 1 : 0), sb);
                at3pContext.gaincCtx.gainCompensation(at3pContext.mdctBuf[ch], sb * 128, this.ctx.prevBuf[ch], sb * 128, this.ctx.channels[ch].gainDataPrev[sb], this.ctx.channels[ch].gainData[sb], 128, at3pContext.timeBuf[ch], sb * 128);
            }
            Arrays.fill(this.ctx.prevBuf[ch], this.ctx.numSubbands * 128, this.ctx.prevBuf[ch].length, 0.0f);
            Arrays.fill(at3pContext.timeBuf[ch], this.ctx.numSubbands * 128, at3pContext.timeBuf[ch].length, 0.0f);
            if (this.ctx.wavesInfo.tonesPresent || this.ctx.wavesInfoPrev.tonesPresent) {
                for (sb = 0; sb < this.ctx.numSubbands; ++sb) {
                    if (this.ctx.channels[ch].tonesInfo[sb].numWavs <= 0 && this.ctx.channels[ch].tonesInfoPrev[sb].numWavs <= 0) continue;
                    this.dsp.generateTones(this.ctx, ch, sb, at3pContext.timeBuf[ch], sb * 128);
                }
            }
            this.dsp.ipqf(at3pContext.ipqfDctCtx, this.ctx.ipqfCtx[ch], at3pContext.timeBuf[ch], at3pContext.outpBuf[ch]);
        }
        for (ch = 0; ch < this.numChannels; ++ch) {
            boolean[] tmp1 = this.ctx.channels[ch].wndShape;
            this.ctx.channels[ch].wndShape = this.ctx.channels[ch].wndShapePrev;
            this.ctx.channels[ch].wndShapePrev = tmp1;
            AtracGainInfo[] tmp2 = this.ctx.channels[ch].gainData;
            this.ctx.channels[ch].gainData = this.ctx.channels[ch].gainDataPrev;
            this.ctx.channels[ch].gainDataPrev = tmp2;
            WavesData[] tmp3 = this.ctx.channels[ch].tonesInfo;
            this.ctx.channels[ch].tonesInfo = this.ctx.channels[ch].tonesInfoPrev;
            this.ctx.channels[ch].tonesInfoPrev = tmp3;
        }
        WaveSynthParams tmp = this.ctx.wavesInfo;
        this.ctx.wavesInfo = this.ctx.wavesInfoPrev;
        this.ctx.wavesInfoPrev = tmp;
    }
}

